// ContentsEscT.cpp : CContentsEscT Class source code
//

#include "stdafx.h"
#include "defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(CContentsEscT, CObject, 1)



// Serialize draw data
void CContentsEscT::Serialize(CArchive& ar)
{
    CObject::Serialize(ar);

    if (ar.IsStoring ())
        ar.Write(&m_Data,sizeof(m_Data)) ;
    else
        ar.Read(&m_Data,sizeof(m_Data)) ;
}

// Draw to Window
void CContentsEscT::Draw(CDC* pDC)
{
	static LOGFONT FontKind = {
	  	8,									// lfHeight
		0,									// lfWidth 
		0,									// lfEscapement
		0,									// lfOrientation
		FW_DONTCARE,						// lfWeight
		0,									// lfItalic
		0,									// lfUnderline
		0,									// lfStrikeOut
		SHIFTJIS_CHARSET,					// lfCharSet  
		OUT_CHARACTER_PRECIS,				// lfOutPrecision 
		CLIP_CHARACTER_PRECIS,				// lfClipPrecision 
		DEFAULT_QUALITY ,					// lfQuality 
		FIXED_PITCH | FF_MODERN,			// lfPitchAndFamily  
	} ;
	strcpy(FontKind.lfFaceName,"lr SVbN") ;	// lfFaceName


	LONG lfWidth  =  8 << (m_Data.cFontSize %  4) ;
	LONG lfHeight = 16 << (m_Data.cFontSize >> 4) ;
	int iLen = strlen(m_Data.szString) ;
	CFont Font ;

	FontKind.lfHeight = lfHeight ;
	FontKind.lfWidth =  lfWidth ;
	Font.CreateFontIndirect(&FontKind);
	CFont *pOldFont = pDC->SelectObject(&Font);

	CRect Rect(m_Data.iX1,m_Data.iY1 - FontKind.lfHeight,m_Data.iX1 + FontKind.lfWidth * iLen ,m_Data.iY1  ) ;

	COLORREF OldBkColor   = pDC->SetBkColor( GpToWinColor(m_Data.cBackColor));
	COLORREF OldTextColor = pDC->SetTextColor( GpToWinColor(m_Data.cDisplayColor)) ;

	pDC->ExtTextOut( m_Data.iX1,m_Data.iY1 - FontKind.lfHeight, ETO_OPAQUE, &Rect, (LPCTSTR)m_Data.szString, NULL);


	pDC->SetBkColor( OldBkColor );
	pDC->SetTextColor( OldTextColor) ;
	pDC->SelectObject(pOldFont);
}

// Transmit the data to GP
int CContentsEscT::Transition( CMemSock* pCMemSock)
{
	return( pCMemSock->MtoMESC_T(m_Data.cDisplayColor,m_Data.cBackColor,m_Data.iX1,m_Data.iY1,m_Data.cFontSize,m_Data.szString)) ;
}
